//
//  MCSourceList.h
//  MCApplication
//
//  Created by Michael Clark on Tue Jul 27 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//


#import "MCSourceListDefines.h"


@class MCSourceListManager;
@class BDQualifier;
@class NSImage;
@protocol MCSourceListHost;

@protocol MCSourceList <NSObject>

- (NSNumber*)primaryKey;

- (NSString*)name;
- (void)setName: (NSString*)aName;
- (NSString*)details;
- (void)setDetails: (NSString*)aDescription;

- (BOOL)isDefault;
- (void)markAsDefault;
- (void)unmarkAsDefault;

- (BOOL)isHidden;
- (void)setHidden: (BOOL)flag;

- (MCSourceListType)type;
- (void)setType: (MCSourceListType)aType;
- (MCSourceListVisibility)visibility;
- (void)setVisibility: (MCSourceListVisibility)aVisibility;
- (int)order;
- (void)setOrder: (int)order;

//- (NSImage*)typeImage;

- (NSString*)entityName;
- (void)setEntityName: (NSString*)anEntityName;

- (NSString*)groupIdentifier;
- (void)setGroupIdentifier: (NSString*)anIdentifier;

- (id)owner;
- (void)setOwner: (id)anOwner;

- (NSDictionary*)queryDisplayState;
- (void)setQueryDisplayState: (NSDictionary*)state;

- (BOOL)containsObject: (id)object;

// Access to the object responsible for storing the display state dictionary
- (id)ownerDisplayStateStorageObject;
- (void)setOwnerDisplayStateStorageObject: (id)state;
- (id)ownerFloatingDisplayStateStorageObject;
- (void)setOwnerFloatingDisplayStateStorageObject: (id)state;
- (id)displayStateStorageObjectForHost: (id <MCSourceListHost>)aHost;
- (void)setDisplayStateStorageObject: (id)state forHost: (id <MCSourceListHost>)aHost;
- (id)floatingDisplayStateStorageObjectForHost: (id <MCSourceListHost>)aHost;
- (void)setFloatingDisplayStateStorageObject: (id)state forHost: (id <MCSourceListHost>)aHost;

// Convenience Accessors to the display state dictionary stored in the display state objects
- (NSMutableDictionary*)ownerDisplayState;
- (void)setOwnerDisplayState: (NSMutableDictionary*)state;
- (NSMutableDictionary*)ownerFloatingDisplayState;
- (void)setOwnerFloatingDisplayState: (NSMutableDictionary*)state;
- (NSMutableDictionary*)displayStateForHost: (id <MCSourceListHost>)aHost;
- (void)setDisplayState: (NSMutableDictionary*)state forHost: (id <MCSourceListHost>)aHost;
- (NSMutableDictionary*)floatingDisplayStateForHost: (id <MCSourceListHost>)aHost;
- (void)setFloatingDisplayState: (NSMutableDictionary*)state forHost: (id <MCSourceListHost>)aHost;

//- (id <MCSourceList>)parentSourceList;
//- (void)setParentSourceList: (id <MCSourceList>)aParent;
//- (NSArray*)subSourceLists;
//- (void)addSubSourceList: (id <MCSourceList>)aSourceList;
//- (void)removeSubSourceList: (id <MCSourceList>)aSourceList;
//- (BOOL)containsSubSourceList: (id <MCSourceList>)aSourceList;

//- (int)displayCount;
//- (void)setDisplayCount: (int)aCount;
//- (void)incrementDisplayCount;
//- (void)decrementDisplayCount;

// objectCount equals the total number of objects in the source list
// newObjectCount is relavant only to watch lists and is the total number of objects newly 
//  qualifying for the watch list's qualifier (each time the watch list is updated this number could change, i.e.
//  if the watch list is processed and there are 3 new objects then the newObjectCount is 3, on the next processing
//  if there is only 1 new object then the newObjectCount is 1.  It is not a cumulative count, it only represents the new
//  objects found on each processing of the watch list.
// unseenObjectCount is relevant only to watch lists and is the total number of objects which have not yet been 
//  opened in the UI
- (NSNumber*)objectCount;
- (void)setObjectCount: (NSNumber*)aCount;
- (NSNumber*)newObjectCount;
- (void)setNewObjectCount: (NSNumber*)aCount;
- (NSNumber*)unseenObjectCount;
- (void)setUnseenObjectCount: (NSNumber*)aCount;

- (MCSourceListManager*)sourceListManager;
- (void)setSourceListManager: (MCSourceListManager*)aSourceListManager;

- (BDQualifier*)qualifier;
- (BDQualifier*)watchListQualifier; // Only works on watch lists!!


- (NSMutableArray*)results;
- (void)setResults: (NSMutableArray*)newResults;

// For KVC compliance and automatice KVO these should be implemented
// Additionally, SourceListManager uses them to update things in the background
//- (unsigned int)countOfResults;
//- (id)objectInResultsAtIndex:(unsigned int)index;
//- (void)insertObject:(id)anObject inResultsAtIndex:(unsigned int)index;
- (void)removeObjectFromResultsAtIndex:(unsigned int)index;
//- (void)replaceObjectInResultsAtIndex:(unsigned int)index withObject:(id)anObject;

// Adds the object to results if a - it's a smart list and qualifies and is not already qualifies or b - it's a dumb list and qualifies(type-wise)
- (BOOL)addObjectIfApplicable:(id)anObj;

// Dumb list management
- (void)dumbListAddObjects: (id)objects;
- (void)dumbListAddObject: (id)object;
- (void)dumbListRemoveObject: (id)object;
- (void)dumbListRemoveObjects:(NSArray *)objs;
- (void)dumbListRemoveAllObjects; // implementers may want this to be optimized

// Convenience methods to add/remove multiple objects at once
- (void)addObjectsToResults: (NSArray*)objects;
- (void)removeObjectsFromResults: (NSArray*)objects;

// if the object ought to be added or removed based on its qualifier, do so...only applies to source lists with qualifiers
- (void)processObjectForQualification: (id)anObject;
- (BOOL)doesObjectPassQualification: (id)anObject;

- (void)willDisplayResults;
- (void)didDisplayResults;

- (BOOL)isQualifiedSourceListType;
@end
